<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payment extends CI_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Categories_model');
        $this->load->model('Payment_model');
        $this->load->model('Settings_model');
        $this->load->library('cart');
    }

    public function index(){
        $data['title'] = 'Pembayaran - ' . $this->Settings_model->general()["app_name"];
        $data['css'] = 'payment';
        $data['setting'] = $this->Settings_model->getSetting();
        $data['provinces'] = $this->Payment_model->getProvinces();
        $this->load->view('templates/header', $data);
        $this->load->view('templates/navbar');
        $this->load->view('page/payment', $data);
        $this->load->view('templates/footerv2');
    }

    public function getSubdistrict(){
        $id = $this->input->post('id');
        $getLocation = $this->Payment_model->getSubdistrict($id);
        $list = "<option></option>";
        foreach($getLocation as $d){
            $list .= "<option value='".$d['subdistrict_id']."'>Kecamatan " . $d['subdistrict_name'] . "";
        }
        echo json_encode($list);
    }

    public function getCourier(){
        $destination = $this->input->post('id');
        $courier = $this->db->get('courier')->row_array();
        $list = "<option>Pilih Kurir</option>";
        if($courier['pos'] == 1){
            $pos = $this->Payment_model->getService("pos",$destination);
            if(count($pos) > 0){
                foreach($pos as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-pos">'."POS"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['jne'] == 1){
            $jne = $this->Payment_model->getService("jne",$destination);
            if(count($jne) > 0){
                foreach($jne as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-jne">'."JNE"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['tiki'] == 1){
            $tiki = $this->Payment_model->getService("tiki",$destination);
            if(count($tiki) > 0){
                foreach($tiki as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-tiki">'."TIKI"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['lion'] == 1){
            $lion = $this->Payment_model->getService("lion",$destination);
            if(count($lion) > 0){
                foreach($lion as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-lion">'."Lion Parcel"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['ninja'] == 1){
            $ninja = $this->Payment_model->getService("ninja",$destination);
            if(count($ninja) > 0){
                foreach($ninja as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-ninja">'."Ninja Xpress"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['ide'] == 1){
            $ide = $this->Payment_model->getService("ide",$destination);
            if(count($ide) > 0){
                foreach($ide as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-ide">'."ID Express"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['sicepat'] == 1){
            $sicepat = $this->Payment_model->getService("sicepat",$destination);
            if(count($sicepat) > 0){
                foreach($sicepat as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-sicepat">'."SiCepat Express"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['sap'] == 1){
            $sap = $this->Payment_model->getService("sap",$destination);
            if(count($sap) > 0){
                foreach($sap as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-sap">'."SAP Express"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['ncs'] == 1){
            $ncs = $this->Payment_model->getService("ncs",$destination);
            if(count($ncs) > 0){
                foreach($ncs as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-ncs">'."NCS"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['anteraja'] == 1){
            $anteraja = $this->Payment_model->getService("anteraja",$destination);
            if(count($anteraja) > 0){
                foreach($anteraja as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-anteraja">'."AnterAja"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['rex'] == 1){
            $rex = $this->Payment_model->getService("rex",$destination);
            if(count($rex) > 0){
                foreach($rex as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-rex">'."Royal Express"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['sc'] == 1){
            $sc = $this->Payment_model->getService("sc",$destination);
            if(count($sc) > 0){
                foreach($sc as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-sc">'."Sentral Cargo"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['rpx'] == 1){
            $rpx = $this->Payment_model->getService("rpx",$destination);
            if(count($rpx) > 0){
                foreach($rpx as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-rpx">'."RPX Holding"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['pandu'] == 1){
            $pandu = $this->Payment_model->getService("pandu",$destination);
            if(count($pandu) > 0){
                foreach($pandu as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-pandu">'."Pandu Logistics"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['wahana'] == 1){
            $wahana = $this->Payment_model->getService("wahana",$destination);
            if(count($wahana) > 0){
                foreach($wahana as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-wahana">'."Wahana"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['jnt'] == 1){
            $jnt = $this->Payment_model->getService("jnt",$destination);
            if(count($jnt) > 0){
                foreach($jnt as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-jnt">'."J&T Express"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['pahala'] == 1){
            $pahala = $this->Payment_model->getService("pahala",$destination);
            if(count($pahala) > 0){
                foreach($pahala as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-pahala">'."Pahala"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['jet'] == 1){
            $jet = $this->Payment_model->getService("jet",$destination);
            if(count($jet) > 0){
                foreach($jet as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-jet">'."JET Express"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['slis'] == 1){
            $slis = $this->Payment_model->getService("slis",$destination);
            if(count($slis) > 0){
                foreach($slis as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-slis">'."Solusi Express"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['expedito'] == 1){
            $expedito = $this->Payment_model->getService("expedito",$destination);
            if(count($expedito) > 0){
                foreach($expedito as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-expedito">'."Expedito"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['dse'] == 1){
            $dse = $this->Payment_model->getService("dse",$destination);
            if(count($dse) > 0){
                foreach($dse as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-dse">'."21 Express"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['first'] == 1){
            $first = $this->Payment_model->getService("first",$destination);
            if(count($first) > 0){
                foreach($first as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-first">'."First Logistics"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['star'] == 1){
            $star = $this->Payment_model->getService("star",$destination);
            if(count($star) > 0){
                foreach($star as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-star">'."Star Cargo"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        if($courier['idl'] == 1){
            $idl = $this->Payment_model->getService("idl",$destination);
            if(count($idl) > 0){
                foreach($idl as $s){
                    $list .= '<option value="'.$s['cost'][0]['value']."-".$s['service'].'-idl">'."IDL Cargo"." ".$s['description']." (".$s['service'].")".'</option>';
                };
            }
        }
        echo json_encode($list);
    }

}
