<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Products extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Categories_model');
		$this->load->model('Products_model');
	}

	public function index()
	{
		$data['products'] = $this->Products_model->getAllProducts(0);
		$data['title'] = 'Semua Produk - ' . $this->Settings_model->general()["app_name"];
		$data['css'] = 'products';
		$data['responsive'] = 'product-responsive';
		$this->load->view('templates/header', $data);
		$this->load->view('templates/navbar');
		$this->load->view('templates/subnavbar');
		$this->load->view('page/products', $data);
		$this->load->view('templates/footer_tmpl');
		$this->load->view('templates/footer_real');
	}

	public function best()
	{
		$data['products'] = $this->Products_model->getAllProductBestSeller(0);
		$data['title'] = 'Produk Terlaris - ' . $this->Settings_model->general()["app_name"];
		$data['css'] = 'products';
		$data['responsive'] = 'product-responsive';
		$this->load->view('templates/header', $data);
		$this->load->view('templates/navbar');
		$this->load->view('templates/subnavbar');
		$this->load->view('page/best_products', $data);
		$this->load->view('templates/footer_tmpl');
		$this->load->view('templates/footer_real');
	}

	public function get_wholesaler_by_count_and_id()
	{
		$id = $_GET['id'];
		$count = $_GET['count'];
		$this->db->where('id_product', $id);
		$this->db->where('count <=', $count);
		$this->db->order_by('id', 'desc');
		$get = $this->db->get('wholesaler')->row_array();
		echo $get['price'];
	}

	public function detail_product($slug)
	{
		$getProduct = $this->Products_model->getProductBySlug($slug);
		if ($getProduct == NULL) {
			redirect(base_url() . '404');
		} else {
			$this->Products_model->updateViewer($slug);
			$data['title'] = $getProduct['title'] . ' - ' . $this->Settings_model->general()["app_name"];
			$data['css'] = 'detail';
			$data['responsive'] = '';
			$data['product'] = $getProduct;
			$data['img'] = $this->Products_model->getImgProductBySlug($slug);
			$data['related'] = $this->Products_model->getRelatedProduct($getProduct['category'], 4);
			$data['color'] = $this->db->get_where('color_product', ['product' => $getProduct['productId']]);
			$data['variant'] = $this->db->get_where('variant', ['product' => $getProduct['productId']]);
			// 
			$config['base_url'] = base_url() . 'p/' . $slug;
			$config['total_rows'] = $this->Products_model->getRating($getProduct['productId'], "", "")->num_rows();
			$config['per_page'] = 3;
			$config['first_link']       = 'First';
			$config['last_link']        = 'Last';
			$config['next_link']        = 'Next';
			$config['prev_link']        = 'Prev';
			$config['full_tag_open']    = '<div class="pagging text-center"><nav><ul class="pagination justify-content-center">';
			$config['full_tag_close']   = '</ul></nav></div>';
			$config['num_tag_open']     = '<li class="page-item"><span class="page-link">';
			$config['num_tag_close']    = '</span></li>';
			$config['cur_tag_open']     = '<li class="page-item active"><span class="page-link">';
			$config['cur_tag_close']    = '<span class="sr-only">(current)</span></span></li>';
			$config['next_tag_open']    = '<li class="page-item"><span class="page-link">';
			$config['next_tagl_close']  = '<span aria-hidden="true">&raquo;</span></span></li>';
			$config['prev_tag_open']    = '<li class="page-item"><span class="page-link">';
			$config['prev_tagl_close']  = '</span>Next</li>';
			$config['first_tag_open']   = '<li class="page-item"><span class="page-link">';
			$config['first_tagl_close'] = '</span></li>';
			$config['last_tag_open']    = '<li class="page-item"><span class="page-link">';
			$config['last_tagl_close']  = '</span></li>';
			$from = $this->uri->segment(3);
			$this->pagination->initialize($config);
			$data['rating'] = $this->Products_model->getRating($getProduct['productId'], $config['per_page'], $from);
			// 
			$this->db->where('status !=', 0);
			$this->db->limit(100);
			$this->db->order_by('id', 'desc');
			$data['invoice'] = $this->db->get('invoice');
			$this->load->view('templates/header', $data);
			$this->load->view('templates/navbar');
			$this->load->view('page/detail', $data);
			$this->load->view('templates/footer_tmpl');
			$this->load->view('templates/footer_real');
		}
	}

	public function save_rating($id)
	{
		$product = $this->db->get_where('products', ['id' => $id])->row_array();
		if ($product) {
			$star = $this->input->post('rating-star');
			$name = $this->input->post('rating-name');
			$review = $this->input->post('rating-review');
			if ($star) {
				$data = [
					'product' => $id,
					'star' => $star,
					'name' => $name,
					'review' => $review,
					'date_rating' => date('Y-m-d H:i:s')
				];
				$this->db->insert('rating', $data);
				$this->session->set_flashdata('sweetalert', "<script>
					swal({
					text: 'Rating berhasil di submit dan menunggu konfirmasi dari admin agar rating dapat ditampilkan',
					icon: 'success'
					});
				</script>");
				redirect(base_url() . 'p/' . $product['slug']);
			} else {
				$this->session->set_flashdata('sweetalert', "<script>
					swal({
					text: 'Harus memilih rating terlebih dahulu.',
					icon: 'warning'
					});
				</script>");
				redirect(base_url() . 'p/' . $product['slug']);
			}
		} else {
			redirect(base_url());
		}
	}

	public function change_price_by_variant()
	{
		$id = $this->input->post('id');
		$size = $this->input->post('variant');
		$result = $this->db->get_where('products', ['id' => $id])->row_array();
		if ($size != NULL) {
			$dbSize = $this->db->get_where('variant', ['type' => $size, 'product' => $id])->row_array();
			if ($result['discount'] == 0) {
				$oldPrice = "";
				$price = "Rp. " . number_format($dbSize['price'], 0, ",", ".");
			} else {
				$diskonnya = ($dbSize['price'] * $result['discount']) / 100;
				$price = $dbSize['price'] - $diskonnya;
				$oldPrice = number_format($dbSize['price'], 0, ",", ".");
				$price = "Rp. " . number_format($price, 0, ",", ".");
			}
		} else {
			if ($result['discount'] == 0) {
				$price = "Rp. " . number_format($result['price'], 0, ",", ".");
			} else {
				$diskonnya = ($result['price'] * $result['discount']) / 100;
				$price = $result['price'] - $diskonnya;
				$oldPrice = number_format($result['price'], 0, ",", ".");
				$price = "Rp. " . number_format($price, 0, ",", ".");
			}
		}
		echo json_encode(["price" => $price, "oldPrice" => $oldPrice]);
	}

	public function get_more_product_home()
	{
		$start = $_GET['start'];
		$data = $this->Products_model->getProductsLimit($start);
		$setting = $this->db->get('settings')->row_array();
		$item = "";
		foreach ($data->result_array() as $p) {
			$starsRating = $this->Products_model->rowRatingByProduct($p['id']);
			if ($p['ex_img'] == 1) {
				$imgFix = $p['img'];
			} else {
				$imgFix = base_url() . 'assets/images/product/' . $p['img'];
			}
			$item .= '<a href="' . base_url() . 'p/' . $p["slug"] . '">
				<div class="item-product">
					<img src="' . $imgFix . '" class="card-img-top" >
					<div class="card-body">
					<p class="card-text mb-0">' . $p['title'] . '</p>';
			if ($p['discount'] == 0) {
				$item .= '<div class="d-flex justify-content-between"><p class="newPrice">Rp ' . str_replace(",", ".", number_format($p['price'])) . '</p>
					<div class="stars-rating">';
				if ($starsRating == 0) {
					$item .= '<i class="far fa-star"></i> <small class="text-muted">' . round($starsRating, 1) . '</small>';
				} else {
					$item .= '<i class="fa fa-star"></i> <small class="text-muted">' . round($starsRating, 1) . '</small>';
				}
				$item .=	'</div>';
			} else {
				$diskonnya = ($p['price'] * $p['discount']) / 100;
				$item .= '<p class="oldPrice mb-0">Rp. <span>' . str_replace(",", ".", number_format($p['price'])) . '</span> <small class="badge badge-danger">' . $p['discount'] . '%</small></p>
				<div class="d-flex justify-content-between"><p class="newPrice">Rp ' . str_replace(",", ".", number_format($p['price'] - $diskonnya)) . '</p>
					<div class="stars-rating">';
				if ($starsRating == 0) {
					$item .= '<i class="far fa-star"></i> <small class="text-muted">' . round($starsRating, 1) . '</small>';
				} else {
					$item .= '<i class="fa fa-star"></i> <small class="text-muted">' . round($starsRating, 1) . '</small>';
				}
				$item .=	'</div>';
			}
			$item .= '</div></div>
				</div>
				</a>';
		}
		echo $item;
	}

	public function get_more_product()
	{
		$start = $_GET['start'];
		$data = $this->Products_model->getAllProducts($start);
		$setting = $this->db->get('settings')->row_array();
		$item = "";
		foreach ($data->result_array() as $p) {
			if ($p['ex_img'] == 1) {
				$imgFix = $p['img'];
			} else {
				$imgFix = base_url() . 'assets/images/product/' . $p['img'];
			}
			$item .= '<a href="' . base_url() . 'p/' . $p["slug"] . '">
				<div class="item-product">
					<img src="' . $imgFix . '" class="card-img-top" >
					<div class="card-body">
					<p class="card-text mb-0">' . $p['title'] . '</p>';
			if ($p['discount'] == 0) {
				$item .= '<p class="newPrice">Rp ' . str_replace(",", ".", number_format($p['price'])) . '</p>';
			} else {
				$diskonnya = ($p['price'] * $p['discount']) / 100;
				$item .= '<p class="oldPrice mb-0">Rp. <span>' . str_replace(",", ".", number_format($p['price'])) . '</span> <small class="badge badge-danger">' . $p['discount'] . '%</small></p>
						<p class="newPrice">Rp ' . str_replace(",", ".", number_format($p['price'] - $diskonnya)) . '</p>';
			}
			$item .= '</div>
				</div>
				</a>';
		}
		echo $item;
	}

	public function get_more_best_product()
	{
		$start = $_GET['start'];
		$data = $this->Products_model->getAllProductBestSeller($start);
		$setting = $this->db->get('settings')->row_array();
		$item = "";
		foreach ($data->result_array() as $p) {
			$starsRating = $this->Products_model->rowRatingByProduct($p['id']);
			if ($p['ex_img'] == 1) {
				$imgFix = $p['img'];
			} else {
				$imgFix = base_url() . 'assets/images/product/' . $p['img'];
			}
			$item .= '<a href="' . base_url() . 'p/' . $p["slug"] . '">
				<div class="item-product">
					<img src="' . $imgFix . '" class="card-img-top" >
					<div class="card-body">
					<p class="card-text mb-0">' . $p['title'] . '</p>';
			if ($p['discount'] == 0) {
				$item .= '<p class="newPrice">Rp ' . str_replace(",", ".", number_format($p['price'])) . '</p>';
			} else {
				$diskonnya = ($p['price'] * $p['discount']) / 100;
				$item .= '<p class="oldPrice mb-0">Rp. <span>' . str_replace(",", ".", number_format($p['price'])) . '</span> <small class="badge badge-danger">' . $p['discount'] . '%</small></p>
						<p class="newPrice">Rp ' . str_replace(",", ".", number_format($p['price'] - $diskonnya)) . '</p>';
			}
			$item .= '</div>
			<div class="stars-rating">
					 ' . $this->rattingStars(round($starsRating, 1)) . '
				</div>
				</div>
				</a>';
		}
		echo $item;
	}

	public function get_more_product_category()
	{
		$start = $_GET['start'];
		$idCat = $_GET['idCat'];
		$sort = $_GET['sort'];
		$data = $this->Products_model->getAllProductsByCategory($idCat, $start, $sort);
		$setting = $this->db->get('settings')->row_array();
		$item = "";
		foreach ($data->result_array() as $p) {
			$starsRating = $this->Products_model->rowRatingByProduct($p['id']);
			if ($p['ex_img'] == 1) {
				$imgFix = $p['img'];
			} else {
				$imgFix = base_url() . 'assets/images/product/' . $p['img'];
			}
			$item .= '<a href="' . base_url() . 'p/' . $p["slug"] . '">
				<div class="item-product">
					<img src="' . $imgFix . '" class="card-img-top" >
					<div class="card-body">
					<p class="card-text mb-0">' . $p['title'] . '</p>';
			if ($p['discount'] == 0) {
				$item .= '<div class="d-flex justify-content-between"><p class="newPrice">Rp ' . str_replace(",", ".", number_format($p['price'])) . '</p>
				<div class="stars-rating">';
				if ($starsRating == 0) {
					$item .= '<i class="far fa-star"></i> <small class="text-muted">' . round($starsRating, 1) . '</small>';
				} else {
					$item .= '<i class="fa fa-star"></i> <small class="text-muted">' . round($starsRating, 1) . '</small>';
				}
				$item .=	'</div>';
			} else {
				$diskonnya = ($p['price'] * $p['discount']) / 100;
				$item .= '<p class="oldPrice mb-0">Rp. <span>' . str_replace(",", ".", number_format($p['price'])) . '</span> <small class="badge badge-danger">' . $p['discount'] . '%</small></p>
			<div class="d-flex justify-content-between"><p class="newPrice">Rp ' . str_replace(",", ".", number_format($p['price'] - $diskonnya)) . '</p>
				<div class="stars-rating">';
				if ($starsRating == 0) {
					$item .= '<i class="far fa-star"></i> <small class="text-muted">' . round($starsRating, 1) . '</small>';
				} else {
					$item .= '<i class="fa fa-star"></i> <small class="text-muted">' . round($starsRating, 1) . '</small>';
				}
				$item .=	'</div>';
			}
			$item .= '</div></div>
			</div>
			</a>';
		}
		echo $item;
	}
	function rattingStars($stars)
	{
		$starRegular = '<i class="far fa-star"></i>';
		$starSolid = '<i class="fa fa-star"></i>';
		$starhalf = '<i class="fa fa-star-half-alt"></i>';
		switch ($stars) {
			case "1":
			case "1.2":
				return $starSolid . $starRegular . $starRegular . $starRegular . $starRegular;
				break;
			case "1.3":
			case "1.4":
			case "1.5":
			case "1.6":
			case "1.7":
				return $starSolid . $starhalf . $starRegular . $starRegular . $starRegular;
				break;
			case "1.8":
			case "1.9":
			case "2":
			case "2.1":
			case "2.2":
				return $starSolid . $starSolid . $starRegular . $starRegular . $starRegular;
				break;
			case "2.3":
			case "2.4":
			case "2.5":
			case "2.6":
			case "2.7":
				return $starSolid . $starSolid . $starhalf . $starRegular . $starRegular;
				break;
			case "2.8":
			case "2.9":
			case "3":
			case "3.1":
			case "3.2":
				return $starSolid . $starSolid . $starSolid . $starRegular . $starRegular;
				break;
			case "3.3":
			case "3.4":
			case "3.5":
			case "3.6":
			case "3.7":
				return $starSolid . $starSolid . $starSolid . $starhalf . $starRegular;
				break;
			case "3.8":
			case "3.9":
			case "4":
			case "4.1":
			case "4.2":
				return $starSolid . $starSolid . $starSolid . $starSolid . $starRegular;
				break;
			case "4.3":
			case "4.4":
			case "4.5":
			case "4.6":
			case "4.7":
				return $starSolid . $starSolid . $starSolid . $starSolid . $starhalf;
				break;
			case "4.8":
			case "4.9":
			case "5":
				return $starSolid . $starSolid . $starSolid . $starSolid . $starSolid;
				break;
			default:
				return $starRegular . $starRegular . $starRegular . $starRegular . $starRegular;
		}
	}
}
