<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order_model extends CI_Model {

    public function getOrders($filter,$number,$offset){
        if($filter == "new"){
            $this->db->where('status', 0);
        }else if($filter == "confirmation"){
            $this->db->where('status', 1);
        }else if($filter == "send"){
            $this->db->where('status', 2);
        }else if($filter == "finish"){
            $this->db->where('status', 3);
        }else if($filter == "cancel"){
            $this->db->where('status', 4);
        }
        $this->db->order_by('id', 'desc');
        return $this->db->get('invoice',$number,$offset);
    }

    public function getOrderByInvoice($id){
        return $this->db->get_where('transaction', ['id_invoice' => $id]);
    }

    public function getDataInvoice($id){
        return $this->db->get_where('invoice', ['invoice_code' => $id])->row_array();
    }

    public function getSearchOrders($key,$number,$offset){
        $this->db->like("invoice_code", $key);
        $this->db->or_like("name", $key);
        $this->db->or_like("telp", $key);
        $this->db->order_by('id', 'desc');
        return $this->db->get('invoice',$number,$offset);
    }

}