<?php echo $this->session->flashdata('upload'); ?>

<!-- Begin Page Content -->
<div class="container-fluid">
	<!-- Page Heading -->
	<h1 class="h4 mb-2 text-gray-800 mb-4">Tambah Produk</h1>

	<!-- DataTales Example -->
	<div class="card shadow mb-4">
		<div class="card-header">
			<a href="<?= base_url(); ?>administrator/products" class="btn px-4 btn-danger">KEMBALI</a>
		</div>
		<div class="card-body">
			<?php echo $this->session->flashdata('failed'); ?>
			<form action="<?= base_url(); ?>administrator/product/add" method="post" enctype="multipart/form-data">
				<div class="form-row">
					<div class="col-md-6">
						<div class="form-group">
							<label for="title">Nama Produk</label>
							<input type="text" class="form-control" id="title" name="title" autocomplete="off" required value="<?php echo set_value('title'); ?>" />
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label for="cat">Kategori</label>
							<select class="form-control" id="cat" name="category">
								<option></option>
								<?php foreach ($categories->result_array() as $c) : ?>
									<option value="<?= $c['id'] ?>"><?= $c['name'] ?></option>
								<?php endforeach; ?>
							</select>
						</div>
					</div>
				</div>
				<div class="form-row">
					<div class="col-md-6">
						<div class="form-group">
							<label for="stock">Stok</label>
							<input type="number" class="form-control" id="stock" name="stock" autocomplete="off" required value=<?php echo set_value('stock'); ?> />
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label for="weight">Berat</label>
							<div class="input-group mb-3">
								<input type="number" class="form-control" id="weight" name="weight" autocomplete="off" required value=<?php echo set_value('weight'); ?> />
								<div class="input-group-append">
									<span class="input-group-text" id="basic-addon2">gr</span>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="form-row">
					<div class="col-md-6">
						<div class="form-group">
							<label for="price">Harga Normal</label>
							<input type="number" class="form-control price-normal-product-addoredit" id="price" name="price" autocomplete="off" required value=<?php echo set_value('price'); ?> />
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label for="discount">Diskon</label>
							<div class="input-group mb-3">
								<input type="number" class="form-control" id="discount" name="discount" autocomplete="off" value=<?php echo set_value('discount'); ?> />
								<div class="input-group-append">
									<span class="input-group-text" id="basic-addon2">%</span>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-6">
						<div class="form-group">
							<div class="custom-control custom-checkbox mr-sm-2">
								<input type="checkbox" class="custom-control-input" id="wholesaler">
								<label class="custom-control-label" for="wholesaler">Harga Grosir</label>
							</div>
							<div class="row mt-2 wrapper-wholesaler" style="display: none;">
								<div class="wrapper-wholesaler-core row container">
									<div class="col-md-4">
										<input type="number" placeholder="Jumlah" autocomplete="off" name="wholesaler_count[]" class="form-control wholesaler-input mb-2">
									</div>
									<div class="col-md-8">
										<input type="number" placeholder="Harga satuan" autocomplete="off" name="wholesaler_price[]" class="form-control wholesaler-input mb-2">
									</div>
								</div>
								<div class="container">
									<button type="button" id="addWholesalerButton" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Tambah</button>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label for="description">Deskripsi</label>
					<textarea class="form-control" id="description" name="description" rows="7"><?php echo set_value('description'); ?></textarea>
				</div>
				<div class="form-row">
					<div class="col-lg-6">
						<div class="form-group">
							<label for="color">Warna</label>
							<input type="text" class="form-control" id="color" placeholder="Kosongkan jika tidak ada warna" name="color" autocomplete="off" value="<?php echo set_value('color'); ?>" />
						</div>
					</div>
					<div class="col-lg-6">
						<div class="form-group">
							<label for="img">Foto Produk Utama</label>
							<input type="file" class="form-control-file" id="img" name="img" autocomplete="off" required value="<?php echo set_value('img'); ?>" />
						</div>
					</div>
				</div>
				<div class="form-row">
					<div class="col-lg-6">
						<div class="form-group">
							<label>Varian</label>
							<input type="text" class="form-control" id="variant_name" placeholder="Nama Varian" name="variant_name" autocomplete="off" value="<?php echo set_value('variant_name'); ?>" />
						</div>
						<div class="form-group" id="formGroupSectionVariantAddProduct">
							<div class="row" id="sectionVariantAddProduct-0">
								<div class="col-lg-6">
									<input type="text" class="form-control" placeholder="Jenis" name="variant_type[]" autocomplete="off" value="<?php echo set_value('variant_type'); ?>" />
								</div>
								<div class="col-lg-5">
									<input type="number" class="form-control" placeholder="Harga" name="variant_price[]" autocomplete="off" value="<?php echo set_value('variant_price'); ?>" />
								</div>
								<div class="col-sm-1">
									<i onclick="deleteVariantAddProduct('0')" style="cursor: pointer" class="fa mt-2 fa-trash h4 text-danger"></i>
								</div>
							</div>
						</div>
						<button type="button" id="btnAddVariantWhenAddProduct" class="btn btn-outline-success"><i class="fa fa-plus"></i> Tambah</button>
					</div>
					<div class="col-lg-6">
						<label>Foto Produk Gallery</label>
						<input type="file" class="form-control-file mb-2" id="img2" name="gallery1" autocomplete="off" value="<?php echo set_value('img2'); ?>" />
						<input type="file" class="form-control-file mb-2" id="img3" name="gallery2" autocomplete="off" value="<?php echo set_value('img3'); ?>" />
						<input type="file" class="form-control-file mb-2" id="img4" name="gallery3" autocomplete="off" value="<?php echo set_value('img4'); ?>" />
						<input type="file" class="form-control-file mb-2" id="img5" name="gallery4" autocomplete="off" value="<?php echo set_value('img5'); ?>" />
					</div>
				</div>
				<div class="form-row mt-3">
					<div class="col-lg-6">
						<div class="form-group">
							<label for="publish">Status</label>
							<select class="form-control" id="publish" name="publish">
								<option value="1">Publish</option>
								<option value="2">Draft</option>
							</select>
						</div>
					</div>
				</div>
				<button type="submit" class="btn mr-3 px-4 btn-primary">SIMPAN PRODUK</button>
			</form>
		</div>
	</div>
</div>
<!-- /.container-fluid -->
<script src="<?= base_url(); ?>assets/admin/libs/jquery/jquery.min.js"></script>
<script>
	$("#wholesaler").on('click', function() {
		if ($("#wholesaler:checked").val() == undefined) {
			$(".wrapper-wholesaler").slideUp('fast');
		} else {
			$(".wrapper-wholesaler").slideDown('fast');
		}
	})
</script>