<?php echo $this->session->flashdata('upload'); ?>

<!-- Begin Page Content -->
<div class="container-fluid">
    <!-- Page Heading -->
    <h1 class="h4 mb-4 text-gray-800 mb-2">Order ID : <?= $invoice['invoice_code']; ?></h1>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <a href="<?= base_url(); ?>administrator/orders" class="btn mr-2 btn-primary px-4"><i class="fa fa-chevron-left"></i> Kembali</a>
            <a href="<?= base_url(); ?>administrator/print_invoice_order/<?= $invoice['invoice_code']; ?>" target="_blank" class="btn float-right mr-2 btn-danger px-4">INVOICE</a>
        </div>
        <div class="card-body">
            <h3 class="lead font-weight-bold">DATA PENERIMA</h3>
            <hr>
            <div class="row">
                <div class="col-md-12">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td>Nama Penerima</td>
                            <td>: <?= $invoice['name']; ?></td>
                        </tr>
                        <tr>
                            <td>No Handphone</td>
                            <td>: <?= $invoice['telp']; ?></td>
                        </tr>
                        <tr>
                            <td>Alamat Lengkap</td>
                            <?php if ($invoice['location']) { ?>
                                <td>: <?= $invoice['address'] ?><br />&nbsp; <?= $invoice['location'] ?></td>
                            <?php } else { ?>
                                <td>: <?= $invoice['address']; ?> Kec. <?= $loc['subdistrict_name']; ?> <?= $loc['type']; ?> <?= $loc['city']; ?></td>
                            <?php } ?>
                        </tr>
                    </table>
                    <br>
                    <h3 class="lead font-weight-bold">DATA ORDER</h3>
                    <hr>
                    <table class="table table-bordered">
                        <tr>
                            <th class="text-center">No.</th>
                            <th class="text-center">Nama Produk</th>
                            <th class="text-center">Varian</th>
                            <th class="text-center">Warna</th>
                            <th class="text-center">Banyak</th>
                            <th class="text-center">Harga</th>
                            <th class="text-center">Total</th>
                            <th class="text-center">Lihat</th>
                            <?php $no = 1;
                            foreach ($orders->result_array() as $data) : ?>
                        </tr>
                        <td class="text-center"><?= $no; ?></td>
                        <td><?= $data['product_name']; ?></td>
                        <td class="text-center"><?= $data['size']; ?></td>
                        <td class="text-center"><?= $data['color']; ?></td>
                        <td class="text-center"><?= $data['qty']; ?></td>
                        <td>Rp<?= number_format($data['price'], 0, ",", "."); ?></td>
                        <?php $total = $data['price'] * $data['qty']; ?>
                        <td>Rp<?= number_format($total, 0, ",", "."); ?></td>
                        <td>
                            <a href="<?= base_url(); ?>p/<?= $data['slug']; ?>" target="_blank" class="btn btn-sm btn-success"><i class="fa fa-eye"></i></a>
                        </td>
                        <tr>
                        <?php $no++;
                            endforeach; ?>
                        </tr>
                    </table>
                    <div class="col-md-6">
                        <table class="table table-borderless table-sm">
                            <tr>
                                <td>Total Harga</td>
                                <td>: Rp <?= number_format($invoice['total_price'], 0, ",", "."); ?></td>
                            </tr>
                            <tr>
                                <?php if ($invoice['location'] == "") { ?>
                                    <td>Biaya Ongkir (<?= strtoupper($invoice['courier']); ?> <?= $invoice['courier_service']; ?>)</td>
                                <?php } else { ?>
                                    <td>Biaya Ongkir</td>
                                <?php } ?>
                                <td>: Rp <?= number_format($invoice['ongkir'], 0, ",", "."); ?></td>
                            </tr>
                            <?php if ($invoice['payment'] == "13") { ?>
                                <tr>
                                    <td>Biaya COD</td>
                                    <td>: Rp <?= number_format($invoice['uniq_number'], 0, ",", "."); ?></td>
                                </tr>
                            <?php } else { ?>
                                <tr>
                                    <td>Kode Unik</td>
                                    <td>: Rp <?= $invoice['uniq_number']; ?></td>
                                </tr>
                            <?php } ?>
                            <?php if ($invoice['potongan'] != 0) { ?>
                                <tr>
                                    <td>Potongan</td>
                                    <td>: Rp <?= number_format($invoice['potongan'], 0, ",", "."); ?></td>
                                </tr>
                            <?php } ?>
                            <tr>
                                <th>Total Keseluruhan</th>
                                <th>: Rp <?= number_format($invoice['total_all'], 0, ",", "."); ?></th>
                            </tr>
                        </table>
                    </div>
                    <hr>
                    <?php if ($invoice['status'] == 0) { ?>
                        <a href="<?= base_url(); ?>administrator/order/<?= $invoice['invoice_code']; ?>/process" onclick="return confirm('Yakin ingin mengkonfirmasi pesanan?');" class="btn mr-3 btn-success px-4">Konfirmasi Pesanan</a>
                    <?php } else if ($invoice['status'] == 1) { ?>
                        <button class="btn mr-3 btn-warning" data-toggle="modal" data-target="#sendingOrder">Kirim Pesanan</button>
                    <?php } ?>
                    <a href="<?= base_url(); ?>administrator/print_label_order/<?= $invoice['invoice_code'] ?>" target="_blank" class="btn btn-dark px-4">Cetak Label</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /.container-fluid -->

<!-- Modal -->
<div class="modal fade" id="sendingOrder" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <form action="<?= base_url(); ?>administrator/order/<?= $invoice['invoice_code']; ?>/sending" method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Kirim Resi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Pastikan Anda sudah mengirim barang kepada kurir dan mendapatkan nomor resi.</p>
                    <div class="form-group">
                        <label for="resi">Masukan Nomor Resi</label>
                        <input type="text" required name="resi" id="resi" class="form-control" autocomplete="off">
                    </div>
                    <small class="text-muted">Setelah menekan tombol dibawah Anda tidak bisa mengubah nomor resi yang sudah Anda masukan.</small>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-info">Yakin dan Kirim</button>
                </div>
            </div>
        </form>
    </div>
</div>