<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>

<div class="d-sm-flex align-items-center justify-content-between mb-4">
  <h4>Dashboard</h4>
  <h1 id="tes"></h1>
  <div class="dropdown mt-4 mt-sm-0">
    <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        <i class="mdi mdi-filter"></i> FILTER 
    </button>
    <!-- <button type="button" class="btn btn-info waves-effect waves-light">Filter</button> -->
    <div class="dropdown-menu dropdown-menu-right">
        <a class="dropdown-item" href="<?= base_url(); ?>administrator?filter=all">All</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator">Today</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator?filter=yesterday">Yesterday</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator?filter=last-week">Last 7 Days</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator?filter=last-month">Last 30 Days</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator?filter=month">This Month</a>
    </div>
  </div>
</div>
                
<div class="row">
  <div class="col-xl-3 col-md-6 mb-4">
    <div class="card text-center shadow h-100 py-2" style="border-left: 3px solid #007bff">
      <div class="card-body pb-0">
        <h4 class="text-primary "><?= $lead->num_rows(); ?></h4>
        <h6"><i class="fas fa-shopping-cart"></i> Lead Masuk</h6>
      </div>
    </div>
  </div>
  <div class="col-xl-3 col-md-6 mb-4">
    <div class="card text-center shadow h-100 py-2" style="border-left: 3px solid #28a745">
      <div class="card-body pb-0">
        <h4 class="text-success font-weight-bold"><?= $order->num_rows(); ?></h4>
        <h6"><i class="fas fa-credit-card"></i> Order Sukses</h6>
      </div>
    </div>
  </div>
  <div class="col-xl-3 col-md-6 mb-4">
    <div class="card text-center shadow h-100 py-2" style="border-left: 3px solid #dc3545">
      <div class="card-body pb-0">
        <?php if($lead->num_rows() == 0){ ?>
          <h4 class="text-danger font-weight-bold">0%</h4>
        <?php }else{ ?>
          <h4 class="text-danger font-weight-bold"><?= substr($order->num_rows() / $lead->num_rows() * 100,0,4) ?>%</h4>
        <?php } ?>
        <h6"><i class="fas fa-percentage"></i> Closing Rate</h6>
      </div>
    </div>
  </div>
  <div class="col-xl-3 col-md-6 mb-4">
    <div class="card text-center shadow h-100 py-2" style="border-left: 3px solid #ffc107">
      <div class="card-body pb-0">
        <h4 class="text-warning font-weight-bold">Rp. <?= number_format($omset,0,",","."); ?></h4>
        <h6"><i class="fas fa-wallet"></i> Total Omset</h6>
      </div>
    </div>
  </div>
</div>

<div class="card">
    <div class="card-body">
        <div id="container-analitik-bulanan"></div>                
    </div>
</div>

<script src="<?=base_url('assets/js/apexcharts.js')?>"></script>
<script type="text/javascript">
	var options = {
    series: [{
    name: 'Lead',
    data: [<?php $date = date('d')+1;
      for ($x = 1; $x < $date; $x++) {
        $statusofff=0;
        foreach ($getInvoiceonoff['statusoff'.$x] as $statusoff) {
            $statusofff =$statusoff->id;

        }
        echo '"'.$statusofff.'"'.',';
      }
      ?>
    ]

    }, {
    name: 'Order',
    data: [
    <?php $date = date('d')+1;
      for ($x = 1; $x < $date; $x++) {
        $statusonn=0;
        foreach ($getInvoiceonoff['statuson'.$x] as $statuson) {
            $statusonn =$statuson->id;
        }
        echo '"'.$statusonn.'"'.',';
      }  

    ?>
    ]
    }],
    chart: {
    height: 350,
    type: 'area'
    },
    dataLabels: {
    enabled: false
    },
    stroke: {
    curve: 'smooth'
    },
    xaxis: {
    type: 'date',
    categories: [
      <?php 
        $date = date('d')+1;
        
        
        $total='';
        for ($x = 1; $x < $date; $x++) {
           
           if($x<10){
            $total = '"'.'0'.$x.'"';
           }else{
            $total = '"'.$x.'"';
           }
            echo $total.',';
            
        }
      ?>
    ]
    },
    tooltip: {
    x: {
    format: 'dd/MM/yy HH:mm'
    },
    },
    };

    var chart = new ApexCharts(document.querySelector("#container-analitik-bulanan"), options);
    chart.render();
</script>