<?php echo $this->session->flashdata('upload'); ?>

<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-3">
<h4 class="mb-0">Data Pesanan</h4>
<div class="d-flex">
  <div class="dropdown mr-3 mt-4 mt-sm-0">
    <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        <i class="mdi mdi-filter"></i> FILTER 
    </button>
    <!-- <button type="button" class="btn btn-primary waves-effect waves-light">Filter</button> -->
    <div class="dropdown-menu dropdown-menu-right">
        <a class="dropdown-item" href="<?= base_url(); ?>administrator/orders">Semua Status</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator/orders?filter=new">Order Baru</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator/orders?filter=confirmation">Konfirmasi</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator/orders?filter=send">Pengiriman</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator/orders?filter=finish">Selesai</a>
        <a class="dropdown-item" href="<?= base_url(); ?>administrator/orders?filter=cancel">Batal</a>
    </div>
  </div>
  <button type="button" onclick="exportTableToExcel('dataTableOrderPage','Data Pesanan')" id="btnExportTableOrderPage" class="btn px-3 btn-success">
		<i class="mdi mdi-download"></i> EXPORT
	</button>
</div>
</div>

<!-- DataTales Example -->
<div class="card shadow mb-4">
	<div class="card-body py-3">
		<div class="d-sm-flex align-items-center justify-content-between">
			<form class="form-inline">
				<select name="action" id="actionOrderPage" class="form-control">
					<option selected disabled>Action</option>
					<option value="1">Konfirmasi</option>
					<option value="2">Pengiriman</option>
					<option value="3">Selesai</option>
					<option value="4">Batal</option>
					<option value="5">Hapus</option>
				</select>
				<button id="btnForApplyActionOrderPage" class="btn ml-2 btn-primary">Apply</button>
			</form>
			<form action="<?=base_url();?>administrator/orders/search" method="get">
				<input type="text" class="form-control" autocomplete="off" placeholder="Search" value="<?= $search; ?>" name="q">
			</form>
		</div>
	</div>
	<div class="card-body">
		<?php echo $this->session->flashdata('failed'); ?> 
		<?php if($orders->num_rows() > 0){ ?>
		<?php if($search){ ?>
			<div class="alert alert-success">Hasil pencarian <strong><?= $search; ?></strong></div>
		<?php } ?>
		<div class="table-responsive">
			<table
				class="table table-bordered"
				id="dataTable"
				width="100%"
				cellspacing="0"
			>
				<thead>
					<tr class="thead-light">
						<th><input type="checkbox" class="checkbox-order-page-main" onchange="checkAllOrders()"></th>
						<th>Order ID</th>
						<th>Nama</th>
						<th>No WhatsApp</th>
						<th>Waktu</th>
						<th>Harga</th>
						<th>Status</th>
						<th>Notifikasi</th>
						<th>Aksi</th>
					</tr>
				</thead>
				<tfoot></tfoot>
				<tbody class="data-content">
					<?php foreach($orders->result_array() as $data): ?>
					<tr>
						<td><input type="checkbox" value="<?= $data['id']; ?>" name="checkboxaction[]" class="checkbox-order-page"></td>
						<td><?= $data['invoice_code']; ?></td>
						<td><?= $data['name']; ?></td>
						<td><?= $data['telp']; ?></td>
						<td><?= date('d-m-Y H:i', strtotime($data['date_input'])); ?></td>
						<td>Rp. <?= number_format($data['total_all'],0,",","."); ?></td>
						<?php if($data['status'] == 0){ ?>
							<td><span style="width: 100px" class="badge px-3 py-2 badge-pill badge-info">Order Baru</span></td>
						<?php }else if($data['status'] == 1){ ?>
							<td><span style="width: 100px" class="badge px-3 py-2 badge-pill badge-success">Konfirmasi</span></td>
						<?php }else if($data['status'] == 2){ ?>
							<td><span style="width: 100px" class="badge px-3 py-2 badge-pill badge-warning">Pengiriman</span></td>
						<?php }else if($data['status'] == 3){ ?>
							<td><span style="width: 100px" class="badge px-3 py-2 badge-pill badge-primary">Selesai</span></td>
						<?php }else{ ?>
							<td><span style="width: 100px" class="badge px-3 py-2 badge-pill badge-danger">Batal</span></td>
						<?php } ?>
						<?php $idParam = $data['id']; $telpParam = $data['telp']; ?>
						<td style="width:155px"><a data-toggle="modal" data-target="#exampleModalCenter" onclick="showModalForActionWhatsappOrder('<?= $idParam; ?>')" class="btn btn-sm btn-success waves-effect waves-light"><i class="fab fa-whatsapp"></i> Action Whatsapp</a></td>
						<td>
							<a href="<?= base_url() ;?>administrator/order/<?= $data['invoice_code']; ?>" class="btn btn-sm btn-primary waves-effect waves-light">Detail</a>
						</td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
			<?= $this->pagination->create_links(); ?>
		</div>
		<?php }else{ ?>
			<?php if($search){ ?>
				<div class="alert alert-danger">Tidak ada hasil untuk <strong><?= $search; ?></strong></div>
			<?php }else{ ?>
				<div class="alert alert-warning" role="alert">
					Opss, belum ada pesanan.
				</div>
			<?php } ?>
		<?php } ?>
	</div>
</div>
<table
	id="dataTableOrderPage"
	style="display: none"
	border="1"
>
	<tr>
		<th style="padding: 10px;">Order ID</th>
		<th style="padding: 10px;">Nama</th>
		<th style="padding: 10px;">No WhatsApp</th>
		<th style="padding: 10px;">Waktu</th>
		<th style="padding: 10px;">Harga</th>
		<th style="padding: 10px;">Status</th>
		<th style="padding: 10px;">Alamat</th>
	</tr>
	<?php foreach($orders->result_array() as $data): ?>
	<tr>
		<td style="padding: 10px"><?= $data['invoice_code']; ?></td>
		<td style="padding: 10px"><?= $data['name']; ?></td>
		<td style="padding: 10px"><?= $data['telp']; ?></td>
		<td style="padding: 10px"><?= date('d-m-Y H:i', strtotime($data['date_input'])); ?></td>
		<td style="padding: 10px">Rp. <?= number_format($data['total_all'],0,",","."); ?></td>
		<?php if($data['status'] == 0){ ?>
			<td style="padding: 10px">Order Baru</td>
		<?php }else if($data['status'] == 1){ ?>
			<td style="padding: 10px">Konfirmasi</td>
		<?php }else if($data['status'] == 2){ ?>
			<td style="padding: 10px">Pengiriman</td>
		<?php }else if($data['status'] == 3){ ?>
			<td style="padding: 10px">Selesai</td>
		<?php }else{ ?>
			<td style="padding: 10px">Batal</td>
		<?php } ?>
		<td style="padding: 10px"><?= $data['address']; ?></td>
	</tr>
	<?php endforeach; ?>
</table>

<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header" style="border-bottom: 1px solid #eee">
        <h5 class="modal-title text-dark" id="exampleModalCenterTitle">Kirim Notifikasi WhatsApp</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true" class="text-dark">&times;</span>
        </button>
      </div>
      <div class="modal-body modal-body-action-whatsapp-orders">
		  <div class="form-group">
			  <select name="type" id="typeSelectToSendNotificationWhatsAppInOrder" class="form-control">
				  <option selected disabled>Pilih Notifikasi</option>
				  <option value="1">Follow Up 1</option>
				  <option value="2">Follow Up 2</option>
				  <option value="3">Follow Up 3</option>
				  <option value="4">Konfirmasi</option>
				  <option value="5">Proses Pengiriman</option>
				  <option value="6">Order Selesai</option>
				  <option value="7">Batal Order</option>
			  </select>
		  </div>
		  <input type="hidden" value="" id="idOrderActionWaOrder">
		  <div class="form-group">
		  	<div class="top tools-text-editor">
					<button data-role="bold" class="btn btn-outline-secondary btn-sm font-weight-bold">B</button>
					<button data-role="italic" class="btn btn-outline-secondary btn-sm font-italic">I</button>
					<button data-role="strikeThrough" class="btn btn-outline-secondary btn-sm" style="text-decoration: line-through;">S</button>
					<small class="text-secondary"></small>
				</div>
				<div class="form-control div-hijrah-to-textarea" id="contentSendNotificationToWhatsApp" style="" contenteditable></div>
		  </div>
        <button id="btnSendNotificationToWhatsAppOrder" class="btn mt-2 btn-info px-4">Kirim</button>
      </div>
    </div>
  </div>
</div>

<!-- <script>
	function addBoldText(){
		document.getElementById("message").value += "*";
	}
	function addItalicText(){
		document.getElementById("message").value += "_";
	}
	function addLineThroughText(){
		document.getElementById("message").value += "~";
	}
</script> -->