<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title><?= $title ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <!-- Light layout Bootstrap Css -->
    <link href="<?= base_url(); ?>assets/admin/css/bootstrap-dark.min.css" id="bootstrap-dark-style" disabled="disabled" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>assets/admin/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="<?= base_url(); ?>assets/admin/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="<?= base_url(); ?>assets/admin/css/app-dark.min.css" id="app-dark-style" disabled="disabled" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>assets/admin/css/app-rtl.min.css" id="app-rtl-style" disabled="disabled" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>assets/admin/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />

</head>

<body>

    <!-- Begin Page Content -->
    <div class="container py-4">
        <!-- Page Heading -->
        <!-- DataTales Example -->
        <div class="card mb-4">
            <div class="card-body">
                <img src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['logo-dark'] ?>" alt="logo" height="30px">
                <h4 class="font-weight-bold float-right">INVOICE</h4>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <h5>Tagihan Untuk:</h5>
                        <h5 class="mt-3 mb-0"><?= $invoice['name']; ?></h5>
                        <?php if ($invoice['location'] == "") { ?>
                            <p class="mt-3"><?= $invoice['address']; ?> Kec. <?= $loc['subdistrict_name']; ?> <?= $loc['type']; ?> <?= $loc['city']; ?></p>
                        <?php } else { ?>
                            <p class="mt-3"><?= $invoice['address']; ?></p>
                        <?php } ?>
                        <p><?= $invoice['telp']; ?></p>

                        <div class="row">
                            <div class="col-lg-6">
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <td>Order ID :</td>
                                        <td><?= $invoice['invoice_code']; ?></td>
                                    </tr>
                                    <tr>
                                        <td>Tanggal Buat :</td>
                                        <td><?= date('d-m-Y', strtotime($invoice['date_input'])); ?></td>
                                    </tr>
                                    <?php $getrek = $this->db->get_where('bank', ['id' => $invoice['payment']])->row_array(); ?>
                                    <?php if ($getrek) { ?>
                                        <tr>
                                            <td>Pembayaran :</td>
                                            <td><?= $getrek['name']; ?></td>
                                        </tr>
                                    <?php } ?>
                                    <?php if ($invoice['payment'] == "13") { ?>
                                        <tr>
                                            <td>Pembayaran :</td>
                                            <td>Cash On Delivery (COD)</td>
                                        </tr>
                                    <?php } ?>
                                </table>
                            </div>
                        </div>
                        <hr>
                        <h5 class="font-weight-bold">DETAIL ORDER</h5>
                        <hr>
                        <table class="table table-bordered">
                            <tr>
                                <th class="text-center">No.</th>
                                <th class="text-center">Nama Produk</th>
                                <th class="text-center">Varian</th>
                                <th class="text-center">Warna</th>
                                <th class="text-center">Banyak</th>
                                <th class="text-center">Harga</th>
                                <th class="text-center">Total</th>
                                <?php $no = 1;
                                foreach ($orders->result_array() as $data) : ?>
                            </tr>
                            <td class="text-center"><?= $no; ?></td>
                            <td><?= $data['product_name']; ?></td>
                            <td class="text-center"><?= $data['size']; ?></td>
                            <td class="text-center"><?= $data['color']; ?></td>
                            <td class="text-center"><?= $data['qty']; ?></td>
                            <td>Rp<?= number_format($data['price'], 0, ",", "."); ?></td>
                            <?php $total = $data['price'] * $data['qty']; ?>
                            <td>Rp<?= number_format($total, 0, ",", "."); ?></td>
                            <tr>
                            <?php $no++;
                                endforeach; ?>
                        </table>
                        <div class="col-md-6 mt-3 float-right">
                            <table class="table table-borderless table-sm">
                                <tr>
                                    <td class="text-right">Total Harga :</td>
                                    <td class="text-right">Rp <?= number_format($invoice['total_price'], 0, ",", "."); ?></td>
                                </tr>
                                <tr>
                                    <?php if ($invoice['location'] == "") { ?>
                                        <td class="text-right">Biaya Ongkir (<?= strtoupper($invoice['courier']); ?> <?= $invoice['courier_service']; ?>) :</td>
                                    <?php } else { ?>
                                        <td class="text-right">Biaya Ongkir</td>
                                    <?php } ?>
                                    <td class="text-right">Rp <?= number_format($invoice['ongkir'], 0, ",", "."); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-right">Kode Unik :</td>
                                    <td class="text-right">Rp <?= $invoice['uniq_number']; ?></td>
                                </tr>
                                <?php if ($invoice['potongan'] != 0) { ?>
                                    <tr>
                                        <td class="text-right">Potongan :</td>
                                        <td class="text-right">Rp <?= number_format($invoice['potongan'], 0, ",", "."); ?></td>
                                    </tr>
                                <?php } ?>
                                <?php if ($invoice['payment'] == "13") { ?>
                                    <tr>
                                        <td class="text-right">Biaya COD :</td>
                                        <td class="text-right">Rp <?= number_format($invoice['uniq_number'], 0, ",", "."); ?></td>
                                    </tr>
                                <?php } ?>
                                <tr>
                                    <th class="text-right">Total Keseluruhan :</th>
                                    <th class="text-right">Rp <?= number_format($invoice['total_all'], 0, ",", "."); ?></th>
                                </tr>
                            </table>
                        </div>
                        <hr>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        window.print();
    </script>

</body>

</html>