<?php echo $this->session->flashdata('upload'); ?>

<!-- Begin Page Content -->
<div class="container-fluid">
	<!-- Page Heading -->
	<h4 class="mb-4">Produk</h4>

	<!-- DataTales Example -->
	<div class="card shadow mb-4">
		<div class="card-body d-flex justify-content-between py-3">
			<div class="d-flex">
				<a href="<?= base_url(); ?>administrator/product/add" class="btn btn-primary">Tambah Produk</a>
				<button class="btn btn-success ml-2" data-toggle="modal" data-target="#importProducts">Import</button>
				<form action="<?= base_url(); ?>administrator/products/search" method="get" class="ml-4">
					<input type="text" class="form-control" autocomplete="off" placeholder="Search" value="<?= $search; ?>" name="q">
				</form>
			</div>
			<div>
				<form class="form-inline">
					<select name="action" id="actionProductPage" class="form-control">
						<option selected disabled>Action</option>
						<option value="1">Publish</option>
						<option value="2">Draf</option>
						<option value="3">Delete</option>
					</select>
					<button id="btnForApplyActionProductPage" class="btn ml-2 btn-primary">Apply</button>
				</form>
			</div>
		</div>
		<div class="card-body">
			<?php echo $this->session->flashdata('failed'); ?>
			<?php if ($getProducts->num_rows() > 0) { ?>
				<?php if ($search) { ?>
					<div class="alert alert-success">Hasil pencarian <strong><?= $search; ?></strong></div>
				<?php } ?>
				<div class="table-responsive">
					<table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
						<thead>
							<tr>
								<th><input type="checkbox" class="checkbox-product-page-main" onchange="checkAllProducts()"></th>
								<th>Foto</th>
								<th>Judul Produk</th>
								<th>Terjual</th>
								<th>Harga</th>
								<th>Stok</th>
								<th>Kategori</th>
								<th style="width: 130px">Aksi</th>
							</tr>
						</thead>
						<tfoot></tfoot>
						<tbody class="data-content">
							<?php foreach ($getProducts->result_array() as $data) : ?>
								<tr>
									<td><input type="checkbox" value="<?= $data['productsId']; ?>" name="checkboxaction[]" class="checkbox-product-page"></td>
									<td style="width: 70px"><img style="width: 70px" src="<?= $data['ex_img'] == 1 ? $data['productsImg'] : base_url() . 'assets/images/product/' . $data['productsImg']; ?>"></td>
									<td><?= $data['productsTitle']; ?></td>
									<td><?= $this->Products_model->totalTransactionProduct($data['slugP']); ?></td>
									<td><?= str_replace(",", ".", number_format($data['productsPrice'])); ?></td>
									<td><?= $data['productsStock']; ?></td>
									<td><?= $data['categoriesName']; ?></td>
									<td width="160px">
										<a href="<?= base_url(); ?>administrator/ratings_product/<?= $data['productsId']; ?>" class="btn btn-sm btn-warning"><i class="fa fa-star"></i></a>
										<a target="_blank" href="<?= base_url(); ?>p/<?= $data['slugP']; ?>" class="btn btn-sm btn-success"><i class="fa fa-eye"></i></a>
										<a href="<?= base_url(); ?>administrator/product/<?= $data['productsId']; ?>/edit" class="btn btn-sm btn-info"><i class="fa fa-pen"></i></a>
										<a href="<?= base_url(); ?>administrator/delete_product/<?= $data['productsId']; ?>" onclick="return confirm('Yakin ingin menghapus produk?')" class="btn btn-sm btn-danger"><i class="fa fa-trash-alt"></i></a>
									</td>
								</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
					<?= $this->pagination->create_links(); ?>
				</div>
			<?php } else { ?>
				<div class="alert alert-warning" role="alert">
					Opss, produk masih kosong, yuk tambah produk sekarang.
				</div>
			<?php } ?>
		</div>
	</div>
</div>

<div class="modal fade" id="importProducts" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Import Produk</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<form action="<?= base_url(); ?>administrator/import_massal_products" method="post" enctype="multipart/form-data">
					<div class="form-group">
						<p class="mt-0"><a target="_blank" href="<?= base_url(); ?>assets/admin/xls/contoh_pengisian_produk.xlsx">Klik disini</a> untuk mengunduh contoh pengisian produk</p>
						<hr>
						<label for="products">File Produk</label>
						<input type="file" class="form-control-file" required name="userfile" id="products" />
					</div>
					<button type="submit" class="btn btn-primary">
						Tambahkan
					</button>
				</form>
			</div>
		</div>
	</div>
</div>
<!-- /.container-fluid -->