<?php
error_reporting(0);
$db_config_path = '../application/config/database.php';
$config_file = '../application/config/config.php';

$success = false;

$url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]";

$config = file_get_contents($config_file);

if (strpos($config, '%BASE_URL%') === false) {
    header('Location: ' . $url);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST) {

    require_once('taskCoreClass.php');
    require_once('includes/databaseLibrary.php');

    $core = new Core();
    $database = new Database();

    if ($core->checkEmpty($_POST) == true) {
        if ($database->create_database($_POST) == false) {
            $message = $core->show_message('error', "Database tidak dapat dibuat, pastikan host, nama pengguna, kata sandi, nama basis data Anda benar");
        } else if ($database->create_tables($_POST) == false) {
            $message = $core->show_message('error', "Database tidak dapat dibuat, pastikan host, nama pengguna, kata sandi, nama basis data Anda benar");
        } else if ($core->checkFile() == false) {
            $message = $core->show_message('error', "File application/config/database.php tidak di temukan silahkan buat terlebih dahulu!");
        } else if ($core->write_config($_POST) == false) {
            $message = $core->show_message('error', "File konfigurasi database tidak dapat ditulis, harap chmod application/config/database.php file ke 777");
        } else if ($core->write_config2($_POST) == false) {
            $message = $core->show_message('error', "File konfigurasi config.php tidak dapat ditulis, harap chmod application/config/config.php file ke 777");
        }

        if (!isset($message)) {
            $urlWb = $core->getAllData($_POST['url']);

            $success = true;
            //header('Location: ' . $urlWb);
        }
    } else {
        $message = $core->show_message('error', 'The host, username, password, database name, and URL are required.');
    }
}


?>
<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Tokoorder Installer</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootswatch/3.3.7/cosmo/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <div class="container">
        <div class="col-md-4 col-md-offset-4">
            <h1>Tokoorder Installer</h1>
            <hr>
            <?php if ($success) : ?>
                <div class="alert alert-success alert-dismissible" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    Instalasi sukses tokoorder app, silahkan login menggunakan username "admin" password "admin", ganti
                    detail login segera setelah berhasil login.
                    <br />
                    <a href="<?php echo $url; ?>/login/admin">Klik di sini untuk login</a>
                </div>
            <?php else : ?>
                <?php
                if (is_writable($db_config_path)) {
                ?>
                    <?php if (isset($message)) {
                        echo '
                <div class="alert alert-info alert-dismissible" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                ' . $message . '
                </div>';
                    } ?>

                    <form id="install_form" method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                        <div class="form-group">
                            <label for="hostname">Hostname</label>
                            <input type="text" id="hostname" value="localhost" class="form-control" name="hostname" required />
                            <p class="help-block">Database Hostname.</p>
                        </div>

                        <div class="form-group">
                            <label for="username">Username</label>
                            <input type="text" id="username" class="form-control" name="username" required />
                            <p class="help-block">Database Username.</p>
                        </div>

                        <div class="form-group">
                            <label for="password">Password</label>
                            <input type="password" id="password" class="form-control" name="password" />
                            <p class="help-block">Database Password.</p>
                        </div>

                        <div class="form-group">
                            <label for="database">Database Name</label>
                            <input type="text" id="database" class="form-control" name="database" required />
                            <p class="help-block">Database Name.</p>
                        </div>

                        <div class="form-group">
                            <label for="url">URL</label>
                            <input type="text" id="url" class="form-control" name="url" value="<?php echo $url; ?>" required />
                            <p class="help-block">URL Website.</p>
                        </div>

                        <input type="submit" value="Install" class="btn btn-primary btn-block" id="submit" />
                    </form>

                <?php
                } else {
                ?>
                    <p class="alert alert-danger">
                        Please make the application/config/database.php file writable.<br>
                        <strong>Example</strong>:<br />
                        <code>chmod 777 application/config/database.php</code>
                    </p>
                <?php
                }
                ?>
            <?php endif; ?>
        </div>

        <footer>
            <div class="col-md-12" style="text-align:center;margin-bottom:20px">
                <hr>By <a href="https://tokoorder.com">tokoorder.com</a>
            </div>
        </footer>
    </div>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js" type="text/javascript"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
</body>


</html>